clear all;
close all;

File = 'Field_Sweep_8K.dat';


%UNTITLED2 Summary of this function goes here
%   Detailed explanaction goes here
%Import data which has [Field, Resistance, Temperature] = Temperature_Splitter(Sample,T)field sweeps at 2, 3, 4, 6, 8, 10K.
A = importdata(File);
Data = A;

%Split data into temeprature, field, and resistance.
Tcol = Data(:,3);
Hcol = Data(:,1);
Rcol = Data(:,2);
n = size(Data,1);

%Set up counters

j = 1;
k = 1;


% Sort data such that it is going in a complete sweep, instead of moving to
% temperature or field.
for i = 1:n
    if Data(i,1) < 0
       Data_N(j,1) = Data(i,1);
       Data_N(j,2) = Data(i,2);
       Data_N(j,3) = Data(i,3);
       j = j + 1;
    else
       Data_P(k,1) = Data(i,1);
       Data_P(k,2) = Data(i,2);
       Data_P(k,3) = Data(i,3);
       k = k + 1;
    end
end

n = size(Data_N,1);
j = 1;

for i = 1:n-1
    Data_N(2*n-j,1) = Data_N(i,1);
    Data_N(2*n-j,2) = Data_N(i,2);
    Data_N(2*n-j,3) = Data_N(i,3);
    j = j + 1;
end

n = size(Data_P,1);
j = 1;

for i = 1:n
    Data_PP((n+1)-i,1) = Data_P(i,1);
    Data_PP((n+1)-i,2) = Data_P(i,2);
    Data_PP((n+1)-i,3) = Data_P(i,3);
end

for i = 1:n-1
    Data_PP(2*n-j,1) = Data_PP(i,1);
    Data_PP(2*n-j,2) = Data_PP(i,2);
    Data_PP(2*n-j,3) = Data_PP(i,3);
    j = j + 1;
end

Data_Final = vertcat(Data_PP,Data_N);

figure;
hold on;
plot(Data_Final(:,1),Data_Final(:,2));
hold off;

Sample = 'Field_Sweep_8K.dat';
save(Sample,'Data_Final','-ascii');
